package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.empreintes;

import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatEmpreinteMessage;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Gnration de l'empreinte d'un message
 *
 */
public class GenererEmpreinteMessage{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(GenererEmpreinteMessage.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param typeAlgo Type de l'algorithme
	 * @param message Message  hasher
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, long typeAlgo, char[] message) throws ExceptionTraitement {

		try{
			
			if(librairie != null) {
			
				if(message != null) {			
				
					CK_MECHANISM algo = new CK_MECHANISM();
					algo.mechanism=typeAlgo;
				
					ResultatEmpreinteMessage resultat = new ResultatEmpreinteMessage("Gnration de l'empreinte d'un message avec "+TraitementsUtil.getNomAlgo(typeAlgo)+" (Initialisation (C_DigestInit))","Gnration de l'empreinte d'un message avec "+TraitementsUtil.getNomAlgo(typeAlgo)+" (Gnration (C_Digest))");
				
					byte[] empreinte = null;
					boolean erreurSurvenue = false;
					
					// Traitements  tester
					try {
						
						//# INIT #//
						librairie.C_DigestInit(idSession, algo);
						
					} catch (PKCS11Exception e) {
						
						log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
						resultat.setCodeRetour(e.getErrorCode());
						erreurSurvenue = true;
						resultat.setCodeRetour2(TraitementsUtil.AUCUN_CODE_RETOUR);
						resultat.appendOperation2(" NON EXECUTEE!");
						
					}
					
					try {
						
						//# GENERATION DU CONDENSAT #//
						if(!erreurSurvenue) {
							
							empreinte = librairie.C_Digest(idSession,new String(message).getBytes());
							if(empreinte != null)
								resultat.setEmpreinte(TraitementsUtil.getHexadecimal(empreinte,null));
							else {
								
								// Si l'empreinte est nulle on lve l'exception
								log.error("L'operation a retourne une empreinte nulle");
								throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_MESSAGE, "L'opration a retourn une empreinte nulle");
								
							}
							
						}
						
					} catch (PKCS11Exception e) {
						
						log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
						resultat.setCodeRetour2(e.getErrorCode());
						
					}
	
					return resultat;
					
				} else {
					
					// Si le message est null il est impossible de raliser l'opration
					log.error("Le message est nul");
					throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_MESSAGE, "Le message est nul");				
					
				}
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_MESSAGE, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_EMPREINTE_MESSAGE, "Une erreur inattendue est survenue");
			
		}

	}
}
